<?php
// Datubāzes savienojuma parametri
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Sāk sesiju, lai pārvaldītu pieslēgšanās statusu
session_start();

// Notīra esošos sesijas datus drošības nolūkos
session_unset();
session_destroy();
session_start();

$error_message = ''; // Iniciē kļūdas ziņojumu

// Pārbauda, vai forma ir iesniegta
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (!empty($email) && !empty($password)) {
        // Izmanto sagatavotus vaicājumus, lai novērstu SQL injekcijas
        $sql = "SELECT * FROM rb_kvalif_signup_410 WHERE email = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            if (password_verify($password, $user['password'])) {
                // Uzstāda sesijas mainīgos
                $_SESSION['logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['first_name'] = $user['first_name'];
                $_SESSION['work_position'] = $user['work_position'];

                // Pāradresē atkarībā no lietotāja lomas
                header("Location: ../php/main.php");
                exit();
            } else {
                $error_message = "Nepareizs e-pasts vai parole.";
            }
        } else {
            $error_message = "Nepareizs e-pasts vai parole.";
        }
        $stmt->close();
    } else {
        $error_message = "Lūdzu, aizpildiet visus laukus.";
    }
}

$conn->close();
include '../html/log-in.html';
?>